#include "win_OpenGLApp.h"

bool COpenGLWinApp::createWindow(HINSTANCE hInstance, char *sTitle, int Width, int Height)
{
	WNDCLASSEX wcex;

	memset(&wcex, 0, sizeof(WNDCLASSEX));

	wcex.cbSize = sizeof(WNDCLASSEX);
	wcex.style = CS_OWNDC | CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc = WndProc;
	wcex.hInstance = hInstance;
	wcex.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wcex.hIconSm = LoadIcon(NULL, IDI_APPLICATION);
	wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcex.lpszClassName = "OpenGL33Win32App";

	if(RegisterClassEx(&wcex) == 0)
	{
		return false;
	}

	DWORD Style = WS_OVERLAPPEDWINDOW | WS_CLIPSIBLINGS | WS_CLIPCHILDREN;

	hWnd = CreateWindowEx(WS_EX_APPWINDOW, wcex.lpszClassName, sTitle, Style, 0, 0, Width, Height, NULL, NULL, hInstance, NULL);

	if(hWnd == NULL)
	{
		return false;
	}

	RECT dRect, wRect, cRect;

	GetWindowRect(GetDesktopWindow(), &dRect);
	GetWindowRect(hWnd, &wRect);
	GetClientRect(hWnd, &cRect);

	wRect.right += Width - cRect.right;
	wRect.bottom += Height - cRect.bottom;
	wRect.right -= wRect.left;
	wRect.bottom -= wRect.top;
	wRect.left = dRect.right / 2 - wRect.right / 2;
	wRect.top = dRect.bottom / 2 - wRect.bottom / 2;

	MoveWindow(hWnd, wRect.left, wRect.top, wRect.right, wRect.bottom, FALSE);

	HDC hDC = GetDC(hWnd);

	if(hDC == NULL)
	{
		return false;
	}

	PIXELFORMATDESCRIPTOR pfd;

	memset(&pfd, 0, sizeof(PIXELFORMATDESCRIPTOR));

	pfd.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DOUBLEBUFFER | PFD_SUPPORT_OPENGL | PFD_DRAW_TO_WINDOW;
	pfd.iPixelType = PFD_TYPE_RGBA;
	pfd.cColorBits = 32;
	pfd.cDepthBits = 24;
	pfd.iLayerType = PFD_MAIN_PLANE;

	int PixelFormat = ChoosePixelFormat(hDC, &pfd);

	if(PixelFormat == 0)
	{
		return false;
	}

	if(SetPixelFormat(hDC, PixelFormat, &pfd) == FALSE)
	{
		return false;
	}

	hRC = wglCreateContext(hDC);

	if(hRC == NULL)
	{
		return false;
	}
	
	if(wglMakeCurrent(hDC, hRC) == FALSE)
	{
		return false;
	}

	if(glewInit() != GLEW_OK)
	{
		return false;
	}

	if(WGLEW_ARB_create_context)
	{
		wglDeleteContext(hRC);

		int GL33RCAttribs[] =
		{
			WGL_CONTEXT_MAJOR_VERSION_ARB, 3,
			WGL_CONTEXT_MINOR_VERSION_ARB, 3,
			WGL_CONTEXT_FLAGS_ARB, WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB,
			0
		};

		hRC = wglCreateContextAttribsARB(hDC, 0, GL33RCAttribs);

		if(hRC == NULL)
		{
			return false;
		}

		if(wglMakeCurrent(hDC, hRC) == FALSE)
		{
			return false;
		}

	}
	else
	{
		return false;
	}

	if(oglControl.Init() == false)
	{
		return false;
	}

	ShowWindow(hWnd, SW_SHOWNORMAL);

	return true;
}

void COpenGLWinApp::appBody()
{
	MSG msg;

	while(GetMessage(&msg, NULL, 0, 0) > 0)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
}

void COpenGLWinApp::shutdown()
{
	if(GLEW_VERSION_3_3)
	{
		oglControl.Destroy();
	}

	wglDeleteContext(hRC);

	DestroyWindow(hWnd);
}

void COpenGLWinApp::OnPaint()
{
	PAINTSTRUCT ps;

	HDC hDC = BeginPaint(hWnd, &ps);

	oglControl.Render();

	SwapBuffers(hDC);

	EndPaint(hWnd, &ps);

	InvalidateRect(hWnd, NULL, FALSE);
}

void COpenGLWinApp::OnSize(int Width, int Height)
{
	oglControl.Resize(Width, Height);
}

COpenGLWinApp appMain;

LRESULT CALLBACK WndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_CLOSE:
			PostQuitMessage(0);
			break;

		case WM_PAINT:
			appMain.OnPaint();
			break;

		case WM_SIZE:
			appMain.OnSize(LOWORD(lParam), HIWORD(lParam));
			break;

		default:
			return DefWindowProc(hWnd, uiMsg, wParam, lParam);
	}
	return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR sCmdLine, int iShow)
{
	if(appMain.createWindow(hInstance, "OpenGL 3.3 Win32 application - Shaders", 800, 600))
	{
		appMain.appBody();
	}

	appMain.shutdown();

	return 0;
}
